//------------------------------------------------------------------
#property copyright "www.forex-tsd.com"
#property link      "www.forex-station.com"
//------------------------------------------------------------------
#property indicator_separate_window
#property indicator_buffers  16
#property indicator_color1   clrNONE; //C'182,70,43'
#property indicator_color2   C'193,227,157'
#property indicator_color3   clrNONE; //C'245,81,81'
#property indicator_color4   C'136,224,202'
#property indicator_color5   clrNONE; //C'245,125,81'
#property indicator_color6   C'140,215,241'
#property indicator_color7   clrNONE; //C'245,109,88'
#property indicator_color8   C'150,191,243'
#property indicator_color9   clrNONE; //C'245,123,78'
#property indicator_color10  C'201,184,243'
#property indicator_color11  clrNONE; //C'245,176,86'
#property indicator_color12  C'244,183,217'
#property indicator_color13  clrNONE; //C'245,183,113'
#property indicator_color14  C'253,161,142'
#property indicator_color15  clrNONE; //C'245,235,93'
#property indicator_color16  C'243,144,155'
#property indicator_width2   2
#property indicator_width4   2
#property indicator_width6   2
#property indicator_width8   2
#property indicator_width10  2
#property indicator_width12  2
#property indicator_width14  2
#property indicator_width16  2

enum StochasticPrices
{
   Low_High, 
   Close_Close
};

extern string                TimeFrame      = "Current time frame";
extern int                   StochKPeriod1  = 14;
extern int                   StochDPeriod1  = 3;
extern int                   StochSlowing1  = 3;
extern StochasticPrices      StochPrice1    = Close_Close;
extern ENUM_MA_METHOD        SignalMode1    = MODE_EMA;
extern string                note2          = "-------------------------";
extern int                   StochKPeriod2  = 14;
extern int                   StochDPeriod2  = 4;
extern int                   StochSlowing2  = 3;
extern StochasticPrices      StochPrice2    = Close_Close;
extern ENUM_MA_METHOD        SignalMode2    = MODE_EMA;
extern string                note3          = "-------------------------";
extern int                   StochKPeriod3  = 14;
extern int                   StochDPeriod3  = 5;
extern int                   StochSlowing3  = 3;
extern StochasticPrices      StochPrice3    = Close_Close;
extern ENUM_MA_METHOD        SignalMode3    = MODE_EMA;
extern string                note4          = "-------------------------";
extern int                   StochKPeriod4  = 14;
extern int                   StochDPeriod4  = 6;
extern int                   StochSlowing4  = 3;
extern StochasticPrices      StochPrice4    = Close_Close;
extern ENUM_MA_METHOD        SignalMode4    = MODE_EMA;
extern string                note5          = "-------------------------";
extern int                   StochKPeriod5  = 14;
extern int                   StochDPeriod5  = 7;
extern int                   StochSlowing5  = 3;
extern StochasticPrices      StochPrice5    = Close_Close;
extern ENUM_MA_METHOD        SignalMode5    = MODE_EMA;
extern string                note6          = "-------------------------";
extern int                   StochKPeriod6  = 14;
extern int                   StochDPeriod6  = 8;
extern int                   StochSlowing6  = 3;
extern StochasticPrices      StochPrice6    = Close_Close;
extern ENUM_MA_METHOD        SignalMode6    = MODE_EMA;
extern string                note7          = "-------------------------";
extern int                   StochKPeriod7  = 14;
extern int                   StochDPeriod7  = 9;
extern int                   StochSlowing7  = 3;
extern StochasticPrices      StochPrice7    = Close_Close;
extern ENUM_MA_METHOD        SignalMode7    = MODE_EMA;
extern string                note8          = "-------------------------";
extern int                   StochKPeriod8  = 14;
extern int                   StochDPeriod8  = 10;
extern int                   StochSlowing8  = 3;
extern StochasticPrices      StochPrice8    = Close_Close;
extern ENUM_MA_METHOD        SignalMode8    = MODE_EMA;
extern string                note9          = "-------------------------";
extern bool                  Interpolate    = true;
extern string                TimeFrame1     = "input 1 for M1; 5 for M5; 30 for M30";
extern string                TimeFrame2     = "60 for H1; 240 for H4; 1440 for D1";

double StochasticMain1[], StochSignal1[], StochasticMain2[], StochSignal2[], StochasticMain3[], StochSignal3[], StochasticMain4[], StochSignal4[], StochasticMain5[], StochSignal5[], StochasticMain6[], StochSignal6[], StochasticMain7[], StochSignal7[], StochasticMain8[], StochSignal8[];
string indicatorFileName;
bool   returnBars, calculateValue;
int    timeFrame, StochPrice1a, StochPrice2a, StochPrice3a, StochPrice4a, StochPrice5a, StochPrice6a, StochPrice7a, StochPrice8a;
//+------------------------------------------------------------------
int OnInit()
{
   SetIndexBuffer(0,StochasticMain1);
   SetIndexBuffer(1,StochSignal1);
   SetIndexBuffer(2,StochasticMain2);
   SetIndexBuffer(3,StochSignal2);
   SetIndexBuffer(4,StochasticMain3);
   SetIndexBuffer(5,StochSignal3);
   SetIndexBuffer(6,StochasticMain4);
   SetIndexBuffer(7,StochSignal4);
   SetIndexBuffer(8,StochasticMain5);
   SetIndexBuffer(9,StochSignal5);
   SetIndexBuffer(10,StochasticMain6);
   SetIndexBuffer(11,StochSignal6);
   SetIndexBuffer(12,StochasticMain7);
   SetIndexBuffer(13,StochSignal7);
   SetIndexBuffer(14,StochasticMain8);
   SetIndexBuffer(15,StochSignal8);
      
         timeFrame         = stringToTimeFrame(TimeFrame);
         indicatorFileName = WindowExpertName();
         calculateValue    = TimeFrame=="calculateValue"; if (calculateValue) { return(0); }
         returnBars        = TimeFrame=="returnBars";     if (returnBars)     { return(0); }
      
      IndicatorShortName(timeFrameToString(timeFrame)+" Stochastic ("+StochKPeriod1+","+StochDPeriod1+","+StochSlowing1+") to ("+StochKPeriod8+","+StochDPeriod8+","+StochSlowing8+")");
   return(0);
}
//+------------------------------------------------------------------
int deinit() { return(0); }
//+------------------------------------------------------------------
int start()
{
   int i,limit,counted_bars=IndicatorCounted();
   
   if (StochPrice1== Low_High) StochPrice1a=0;
   else StochPrice1a = 1;
   
   if (StochPrice2== Low_High) StochPrice2a=0;
   else StochPrice2a = 1;
   
   if (StochPrice3== Low_High) StochPrice3a=0;
   else StochPrice3a = 1;
   
   if (StochPrice4== Low_High) StochPrice4a=0;
   else StochPrice4a = 1;
   
   if (StochPrice5== Low_High) StochPrice5a=0;
   else StochPrice5a = 1;
   
   if (StochPrice6== Low_High) StochPrice6a=0;
   else StochPrice6a = 1;
   
   if (StochPrice7== Low_High) StochPrice7a=0;
   else StochPrice7a = 1;
   
   if (StochPrice8== Low_High) StochPrice8a=0;
   else StochPrice8a = 1;

      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
         limit = MathMin(Bars-counted_bars,Bars-1);
         if (returnBars) { StochasticMain1[0] = MathMin(limit+1,Bars-1); return(0); }

   if (calculateValue || timeFrame == Period())
   {
      for(i=limit; i>=0; i--)
      {
         StochasticMain1[i] = iStochastic(NULL,0,StochKPeriod1,StochDPeriod1,StochSlowing1,SignalMode1,StochPrice1a,MODE_MAIN  ,i);
         StochSignal1[i]    = iStochastic(NULL,0,StochKPeriod1,StochDPeriod1,StochSlowing1,SignalMode1,StochPrice1a,MODE_SIGNAL,i);
         
         StochasticMain2[i] = iStochastic(NULL,0,StochKPeriod2,StochDPeriod2,StochSlowing2,SignalMode2,StochPrice2a,MODE_MAIN  ,i);
         StochSignal2[i]    = iStochastic(NULL,0,StochKPeriod2,StochDPeriod2,StochSlowing2,SignalMode2,StochPrice2a,MODE_SIGNAL,i);
         
         StochasticMain3[i] = iStochastic(NULL,0,StochKPeriod3,StochDPeriod3,StochSlowing3,SignalMode3,StochPrice3a,MODE_MAIN  ,i);
         StochSignal3[i]    = iStochastic(NULL,0,StochKPeriod3,StochDPeriod3,StochSlowing3,SignalMode3,StochPrice3a,MODE_SIGNAL,i);
         
         StochasticMain4[i] = iStochastic(NULL,0,StochKPeriod4,StochDPeriod4,StochSlowing4,SignalMode4,StochPrice4a,MODE_MAIN  ,i);
         StochSignal4[i]    = iStochastic(NULL,0,StochKPeriod4,StochDPeriod4,StochSlowing4,SignalMode4,StochPrice4a,MODE_SIGNAL,i);
         
         StochasticMain5[i] = iStochastic(NULL,0,StochKPeriod5,StochDPeriod5,StochSlowing5,SignalMode5,StochPrice5a,MODE_MAIN  ,i);
         StochSignal5[i]    = iStochastic(NULL,0,StochKPeriod5,StochDPeriod5,StochSlowing5,SignalMode5,StochPrice5a,MODE_SIGNAL,i);
         
         StochasticMain6[i] = iStochastic(NULL,0,StochKPeriod6,StochDPeriod6,StochSlowing6,SignalMode6,StochPrice6a,MODE_MAIN  ,i);
         StochSignal6[i]    = iStochastic(NULL,0,StochKPeriod6,StochDPeriod6,StochSlowing6,SignalMode6,StochPrice6a,MODE_SIGNAL,i);
         
         StochasticMain7[i] = iStochastic(NULL,0,StochKPeriod7,StochDPeriod7,StochSlowing7,SignalMode7,StochPrice7a,MODE_MAIN  ,i);
         StochSignal7[i]    = iStochastic(NULL,0,StochKPeriod7,StochDPeriod7,StochSlowing7,SignalMode7,StochPrice7a,MODE_SIGNAL,i);
         
         StochasticMain8[i] = iStochastic(NULL,0,StochKPeriod8,StochDPeriod8,StochSlowing8,SignalMode8,StochPrice8a,MODE_MAIN  ,i);
         StochSignal8[i]    = iStochastic(NULL,0,StochKPeriod8,StochDPeriod8,StochSlowing8,SignalMode8,StochPrice8a,MODE_SIGNAL,i);
      }         
      return(0);
   }
   
   limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrame,indicatorFileName,"returnBars",0,0)*timeFrame/Period()));
   for (i=limit; i>=0; i--)
   {
      int y = iBarShift(NULL,timeFrame,Time[i]);
         StochasticMain1[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",StochKPeriod1,StochDPeriod1,StochSlowing1,StochPrice1a,SignalMode1,0,y);
         StochSignal1[i]    = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",StochKPeriod1,StochDPeriod1,StochSlowing1,StochPrice1a,SignalMode1,1,y);

         StochasticMain2[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",StochKPeriod2,StochDPeriod2,StochSlowing2,StochPrice2a,SignalMode2,0,y);
         StochSignal2[i]    = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",StochKPeriod2,StochDPeriod2,StochSlowing2,StochPrice2a,SignalMode2,1,y);

         StochasticMain3[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",StochKPeriod3,StochDPeriod3,StochSlowing3,StochPrice3a,SignalMode3,0,y);
         StochSignal3[i]    = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",StochKPeriod3,StochDPeriod3,StochSlowing3,StochPrice3a,SignalMode3,1,y);

         StochasticMain4[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",StochKPeriod4,StochDPeriod4,StochSlowing4,StochPrice4a,SignalMode4,0,y);
         StochSignal4[i]    = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",StochKPeriod4,StochDPeriod4,StochSlowing4,StochPrice4a,SignalMode4,1,y);

         StochasticMain5[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",StochKPeriod5,StochDPeriod5,StochSlowing5,StochPrice5a,SignalMode5,0,y);
         StochSignal5[i]    = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",StochKPeriod5,StochDPeriod5,StochSlowing5,StochPrice5a,SignalMode5,1,y);

         StochasticMain6[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",StochKPeriod6,StochDPeriod6,StochSlowing6,StochPrice6a,SignalMode6,0,y);
         StochSignal6[i]    = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",StochKPeriod6,StochDPeriod6,StochSlowing6,StochPrice6a,SignalMode6,1,y);

         StochasticMain7[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",StochKPeriod7,StochDPeriod7,StochSlowing7,StochPrice7a,SignalMode7,0,y);
         StochSignal7[i]    = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",StochKPeriod7,StochDPeriod7,StochSlowing7,StochPrice7a,SignalMode7,1,y);

         StochasticMain8[i] = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",StochKPeriod8,StochDPeriod8,StochSlowing8,StochPrice8a,SignalMode8,0,y);
         StochSignal8[i]    = iCustom(NULL,timeFrame,indicatorFileName,"calculateValue",StochKPeriod8,StochDPeriod8,StochSlowing8,StochPrice8a,SignalMode8,1,y);

          if (timeFrame <= Period() || y==iBarShift(NULL,timeFrame,Time[i-1])) continue;
          if (!Interpolate) continue;

          datetime time = iTime(NULL,timeFrame,y);
             for(int n = 1; i+n < Bars && Time[i+n] >= time; n++) continue;	
             for(int x = 1; x < n; x++)
             {
                StochasticMain1[i+x] = StochasticMain1[i] + (StochasticMain1[i+n] - StochasticMain1[i]) * x/n;
                StochSignal1[i+x]    = StochSignal1[i]    + (StochSignal1[i+n]    - StochSignal1[i])    * x/n;
                
                StochasticMain2[i+x] = StochasticMain2[i] + (StochasticMain2[i+n] - StochasticMain2[i]) * x/n;
                StochSignal2[i+x]    = StochSignal2[i]    + (StochSignal2[i+n]    - StochSignal2[i])    * x/n;
                
                StochasticMain3[i+x] = StochasticMain3[i] + (StochasticMain3[i+n] - StochasticMain3[i]) * x/n;
                StochSignal3[i+x]    = StochSignal3[i]    + (StochSignal3[i+n]    - StochSignal3[i])    * x/n;
                
                StochasticMain4[i+x] = StochasticMain4[i] + (StochasticMain4[i+n] - StochasticMain4[i]) * x/n;
                StochSignal4[i+x]    = StochSignal4[i]    + (StochSignal4[i+n]    - StochSignal4[i])    * x/n;
                
                StochasticMain5[i+x] = StochasticMain5[i] + (StochasticMain5[i+n] - StochasticMain5[i]) * x/n;
                StochSignal5[i+x]    = StochSignal5[i]    + (StochSignal5[i+n]    - StochSignal5[i])    * x/n;
                
                StochasticMain6[i+x] = StochasticMain6[i] + (StochasticMain6[i+n] - StochasticMain6[i]) * x/n;
                StochSignal6[i+x]    = StochSignal6[i]    + (StochSignal6[i+n]    - StochSignal6[i])    * x/n;
                
                StochasticMain7[i+x] = StochasticMain7[i] + (StochasticMain7[i+n] - StochasticMain7[i]) * x/n;
                StochSignal7[i+x]    = StochSignal7[i]    + (StochSignal7[i+n]    - StochSignal7[i])    * x/n;
                
                StochasticMain8[i+x] = StochasticMain8[i] + (StochasticMain8[i+n] - StochasticMain8[i]) * x/n;
                StochSignal8[i+x]    = StochSignal8[i]    + (StochSignal8[i+n]    - StochSignal8[i])    * x/n;
             }               
   }         
   return(0);
   
}
//-------------------------------------------------------------------
string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

int stringToTimeFrame(string tfs) {
   StringToUpper(tfs);
   for (int i=ArraySize(iTfTable)-1; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[i],Period()));
                                                      return(Period());
}
//+------------------------------------------------------------------
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}
//+------------------------------------------------------------------
string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int tchar = StringGetChar(s, length);
         if((tchar > 96 && tchar < 123) || (tchar > 223 && tchar < 256))
                     s = StringSetChar(s, length, tchar - 32);
         else if(tchar > -33 && tchar < 0)
                     s = StringSetChar(s, length, tchar + 224);
   }
   return(s);
}
//+------------------------------------------------------------------
